function [IRF_a, IRF_u] = IRF_series_fracking(struct_param, shock_param, endo_ss)
% This function computes the Impulse Response Function given model
% parameters.

global oo_

save calibration_parameters struct_param shock_param endo_ss

evalc('dynare World_Economy_Cartel_Fracking_IRF.mod');   % Run model

var_names   = {'a' 'u' 'p' 'prod_n' 'prod_o' 'prod_f' 'theta_n' 'theta_o' 'theta_f' ...
               'F_n' 'F_o' 'F_f' 'I_n' 'I_o' 'I_f' 'Y' 'L' 'K' 'C' 'r' 'o' 'X_n', 'X_o', 'X_f'};
shock_names = {'a' 'u'};

for i = 1:2
    for j = 1:length(var_names)
        eval(['IRF_' shock_names{i} '.' var_names{j} ' = oo_.irfs.' var_names{j} '_eps_' shock_names{i} ';']);
    end
end
